%% Declare and define transition matrix
T=[0.2,0.1,0,0; 0.3,0.7,0.2,0; 0.5,0.2,0.5,0; 0,0,0.3,1]


%% Generate a set of trajectories
numTraj=40;%generate 40 trajectories
lenTraj=25;%each trajectory has 25 steps
recordTraj=zeros(numTraj,lenTraj+1);%Record trajectories that are sampled. 100 steps => 101 states to be saved

for k=1:numTraj %loop over trajectories
    currentState=1; %state variable; set up as A initially.
    recordTraj(k,1)=currentState; 
    
    for l=1:lenTraj %update state the required number of times
        r=rand(); %generate random number to chose destination
        m=0; % define variable to count cumulative probability
        
        for newState=1:4 %loop over possible destinations
            m=m+T(newState,currentState); %caclulate cumulative probability
            if m>r
                currentState=newState; %update
                break;
            end
        end
        recordTraj(k,l+1)=currentState;
    end
    plot(recordTraj(k,:),'b-d');
    pause(2);
end
    
